PSCAD 4.2.0

Settings
 {
 Id = "913141739.1130362963"
 Author = "jayas.jayas"
 Desc = " Wind generator with a soft starter"
 Arch = "windows"
 Options = 0
 Build = 18
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 60
  Step = 5e-005
  Plot = 0.00025
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "Untitled.out"
  SFile = "AutoSnap.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }

 }

Definitions
 {
 Module("Breaker")
  {
  Desc = ""
  FileDate = 1130360902
  Nodes = 
   {
   Electrical("N1",-72,0)
    {
    Dim  = [3]
    }
   Electrical("N2",36,0)
    {
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Pen(,,0.6)
   Line(-72,0,-24,0)
   Rectangle(-24,-7,-11,7)
   Line(-11,0,36,0)
   Line(17,-57,-8,-57)
   Line(-8,-48,-8,-66)
   Line(-8,-57,-26,-66)
   Line(-26,-66,-26,-48)
   Line(-26,-48,-8,-57)
   Line(-26,-57,-55,-57)
   Line(-8,-57,-2,-68)
   Line(-55,-30,-27,-30)
   Line(-27,-21,-27,-39)
   Line(-27,-30,-9,-39)
   Line(-9,-39,-9,-21)
   Line(-9,-21,-27,-30)
   Line(-9,-30,17,-30)
   Line(-27,-30,-34,-41)
   Line(18,0,18,-57)
   Line(-55,0,-55,-58)
   Text(-18,21,"Breaker")
   }


  Page(A/A4,Portrait,16,[619,473],100)
   {
   0.compare([594,774],0,0,100)
    {
    X = "5"
    OL = "1"
    OH = "0"
    INTR = "0"
    }
   0.datalabel([666,774],0,0,-1)
    {
    Name = "BRK"
    }
   0.time-sig([486,774],0,0,90)
    {
    }
   -Wire-([522,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.unity([666,774],0,0,110)
    {
    IType = "2"
    OType = "1"
    }
   0.breaker3([468,612],0,0,450)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "0"
    ViewB = "0"
    DisPQ = "0"
    NAME = "BRK"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0E6 [ohm]"
    RON = "0.00001 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = ""
    IBRB = ""
    IBRC = ""
    IBR0 = ""
    SBRA = ""
    SBRB = ""
    SBRC = ""
    BP = ""
    BQ = ""
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "0 [MW]"
    Q = "0 [MVAR]"
    }
   -Wire-([504,576],0,0,-1)
    {
    Vertex="0,0;234,0"
    }
   -Wire-([504,612],0,0,-1)
    {
    Vertex="0,0;234,0"
    }
   -Wire-([504,648],0,0,-1)
    {
    Vertex="0,0;234,0"
    }
   -Wire-([162,648],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   -Wire-([162,612],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   -Wire-([162,576],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   0.xnode([126,612],0,0,-1)
    {
    Name = "N1"
    }
   0.xnode([846,612],0,0,-1)
    {
    Name = "N2"
    }
   -Wire-([486,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([522,504],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([414,504],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([450,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([522,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([486,198],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([414,252],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([450,198],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([414,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([522,378],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([522,378],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([414,378],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([450,324],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([414,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([486,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([522,252],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([522,252],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([414,378],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   -Wire-([522,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([522,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([414,252],0,0,-1)
    {
    Vertex="0,0;-162,0"
    }
   -Wire-([414,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([522,504],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([414,504],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   0.peswitch([486,198],3,0,340)
    {
    L = "T"
    Type = "1"
    SNUB = "0"
    INTR = "1"
    RON = "0.001 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    I = "Thyr1A"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([450,252],1,0,330)
    {
    L = "T"
    Type = "1"
    SNUB = "0"
    INTR = "1"
    RON = "0.001 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    I = "Thyr2A"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([486,324],3,0,510)
    {
    L = "T"
    Type = "1"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    I = "Thyr1B"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([450,378],1,0,500)
    {
    L = "T"
    Type = "1"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    I = "Thyr2B"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([486,450],3,0,480)
    {
    L = "T"
    Type = "1"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    I = "Thyr1C"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = "Alpha2"
    Gamma = "Gamma2"
    }
   0.peswitch([450,504],1,0,470)
    {
    L = "T"
    Type = "1"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    I = "Thyr2C"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = "Alpha"
    Gamma = "Gamma"
    }
   -Wire-([720,576],0,0,-1)
    {
    Vertex="0,0;0,-324"
    }
   -Wire-([252,576],0,0,-1)
    {
    Vertex="0,0;0,-324"
    }
   -Wire-([288,612],0,0,-1)
    {
    Vertex="0,0;0,-234"
    }
   -Wire-([684,612],0,0,-1)
    {
    Vertex="0,0;0,-234"
    }
   -Wire-([648,648],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   -Wire-([324,648],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   0.voltmetergnd([720,576],0,0,30)
    {
    Name = "Ea"
    }
   0.voltmetergnd([684,612],0,0,50)
    {
    Name = "Eb"
    }
   0.voltmetergnd([648,648],0,0,70)
    {
    Name = "Ec"
    }
   0.datalabel([1062,1386],0,0,-1)
    {
    Name = "Ea"
    }
   -Wire-([1062,1386],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1134,1386],0,29405720,260)
    {
    Name = "Ea"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.datalabel([1062,1422],0,0,-1)
    {
    Name = "Eb"
    }
   -Wire-([1062,1422],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1134,1422],0,29410024,280)
    {
    Name = "Eb"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.datalabel([1062,1458],0,0,-1)
    {
    Name = "Ec"
    }
   -Wire-([1062,1458],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1134,1458],0,29416256,290)
    {
    Name = "Ec"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.ammeter([774,576],2,0,40)
    {
    Name = "ILa"
    }
   0.datalabel([1062,1206],0,0,-1)
    {
    Name = "ILa"
    }
   -Wire-([1062,1206],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1134,1206],0,29421696,180)
    {
    Name = "ILa"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-60.0"
    Max = "60.0"
    }
   -Wire-([36,1188],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([90,1134],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   -Wire-([90,1134],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([198,1098],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([198,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([252,1170],0,0,-1)
    {
    Name = "FP1"
    }
   0.datalabel([252,1296],0,0,-1)
    {
    Name = "FP2"
    }
   0.datalabel([216,1440],2,0,-1)
    {
    Name = "ANG_1"
    }
   0.fp_int([252,1098],0,0,300)
    {
    Type = "0"
    PNum = "0"
    Blck = "0"
    PFormat = "0"
    detect = "0"
    max = "360.0"
    min = "0.0"
    BType = "0"
    PTime = "0.005 [s]"
    }
   0.fp_int([252,1224],0,0,320)
    {
    Type = "0"
    PNum = "0"
    Blck = "0"
    PFormat = "0"
    detect = "0"
    max = "360.0"
    min = "0.0"
    BType = "0"
    PTime = "0.005 [s]"
    }
   -Wire-([198,1224],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([162,1332],3,0,190)
    {
    Name = ""
    Value = "180"
    }
   0.sumjct([162,1260],0,0,310)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([90,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.tvekta([144,1440],0,0,240)
    {
    Gp = "50.0"
    Gi = "900.0"
    Vbas = "1.0 [V]"
    Fbas = "60.0 [Hz]"
    Mode = "0"
    PMode = "1"
    THOFF = "0.0"
    TREL = "0.05"
    dlead = "1"
    FName = ""
    Err = ""
    }
   0.datalabel([108,1404],0,0,-1)
    {
    Name = "Ea"
    }
   0.datalabel([108,1440],0,0,-1)
    {
    Name = "Eb"
    }
   0.datalabel([108,1476],0,0,-1)
    {
    Name = "Ec"
    }
   0.tvekta([432,1440],0,0,250)
    {
    Gp = "50.0"
    Gi = "900.0"
    Vbas = "1.0 [V]"
    Fbas = "60.0 [Hz]"
    Mode = "0"
    PMode = "1"
    THOFF = "0.0"
    TREL = "0.05"
    dlead = "1"
    FName = ""
    Err = ""
    }
   0.datalabel([396,1404],0,0,-1)
    {
    Name = "Eb"
    }
   0.datalabel([396,1440],0,0,-1)
    {
    Name = "Ec"
    }
   0.datalabel([396,1476],0,0,-1)
    {
    Name = "Ea"
    }
   0.tvekta([792,1440],0,0,270)
    {
    Gp = "50.0"
    Gi = "900.0"
    Vbas = "1.0 [V]"
    Fbas = "60.0 [Hz]"
    Mode = "0"
    PMode = "1"
    THOFF = "0.0"
    TREL = "0.05"
    dlead = "1"
    FName = ""
    Err = ""
    }
   0.datalabel([756,1404],0,0,-1)
    {
    Name = "Ec"
    }
   0.datalabel([756,1440],0,0,-1)
    {
    Name = "Ea"
    }
   0.datalabel([756,1476],0,0,-1)
    {
    Name = "Eb"
    }
   0.datalabel([198,1224],2,0,-1)
    {
    Name = "ANG_1"
    }
   0.datalabel([198,1098],2,0,-1)
    {
    Name = "ANG_1"
    }
   0.datalabel([504,1440],2,0,-1)
    {
    Name = "ANG_2"
    }
   0.datalabel([864,1440],2,0,-1)
    {
    Name = "ANG_3"
    }
   -Wire-([324,1188],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([378,1134],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   -Wire-([378,1134],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([486,1098],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([486,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([540,1170],0,0,-1)
    {
    Name = "FP3"
    }
   0.datalabel([540,1296],0,0,-1)
    {
    Name = "FP4"
    }
   0.fp_int([540,1098],0,0,430)
    {
    Type = "0"
    PNum = "0"
    Blck = "0"
    PFormat = "0"
    detect = "0"
    max = "360.0"
    min = "0.0"
    BType = "0"
    PTime = "0.005 [s]"
    }
   0.fp_int([540,1224],0,0,410)
    {
    Type = "0"
    PNum = "0"
    Blck = "0"
    PFormat = "0"
    detect = "0"
    max = "360.0"
    min = "0.0"
    BType = "0"
    PTime = "0.005 [s]"
    }
   -Wire-([486,1224],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([450,1332],3,0,210)
    {
    Name = ""
    Value = "180"
    }
   0.sumjct([450,1260],0,0,400)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([378,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([486,1224],2,0,-1)
    {
    Name = "ANG_2"
    }
   0.datalabel([486,1098],2,0,-1)
    {
    Name = "ANG_2"
    }
   -Wire-([666,1188],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,1134],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   -Wire-([720,1134],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([828,1098],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([828,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([882,1170],0,0,-1)
    {
    Name = "FP5"
    }
   0.datalabel([882,1296],0,0,-1)
    {
    Name = "FP6"
    }
   0.fp_int([882,1098],0,0,420)
    {
    Type = "0"
    PNum = "0"
    Blck = "0"
    PFormat = "0"
    detect = "0"
    max = "360.0"
    min = "0.0"
    BType = "0"
    PTime = "0.005 [s]"
    }
   0.fp_int([882,1224],0,0,390)
    {
    Type = "0"
    PNum = "0"
    Blck = "0"
    PFormat = "0"
    detect = "0"
    max = "360.0"
    min = "0.0"
    BType = "0"
    PTime = "0.005 [s]"
    }
   -Wire-([828,1224],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([792,1332],3,0,230)
    {
    Name = ""
    Value = "180"
    }
   0.sumjct([792,1260],0,0,380)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([720,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([828,1224],2,0,-1)
    {
    Name = "ANG_3"
    }
   0.datalabel([828,1098],2,0,-1)
    {
    Name = "ANG_3"
    }
   0.datalabel([36,1188],0,0,-1)
    {
    Name = "ANG"
    }
   0.datalabel([324,1188],0,0,-1)
    {
    Name = "ANG"
    }
   0.datalabel([666,1188],0,0,-1)
    {
    Name = "ANG"
    }
   0.datalabel([450,108],2,0,-1)
    {
    Name = "FP1"
    }
   0.datalabel([486,288],0,0,-1)
    {
    Name = "FP2"
    }
   0.datalabel([450,288],2,0,-1)
    {
    Name = "FP3"
    }
   0.datalabel([486,414],0,0,-1)
    {
    Name = "FP4"
    }
   0.datalabel([450,414],2,0,-1)
    {
    Name = "FP5"
    }
   0.datalabel([486,540],0,0,-1)
    {
    Name = "FP6"
    }
   0.datalabel([1062,1242],0,0,-1)
    {
    Name = "ILb"
    }
   -Wire-([1062,1242],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1134,1242],0,29459528,200)
    {
    Name = "ILb"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-60.0"
    Max = "60.0"
    }
   0.datalabel([1062,1278],0,0,-1)
    {
    Name = "ILc"
    }
   -Wire-([1062,1278],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1134,1278],0,29463640,220)
    {
    Name = "ILc"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-60.0"
    Max = "60.0"
    }
   0.ammeter([774,612],2,0,60)
    {
    Name = "ILb"
    }
   0.ammeter([774,648],2,0,80)
    {
    Name = "ILc"
    }
   -Wire-([774,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([468,126],3,0,350)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([468,126],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([540,126],0,29469840,530)
    {
    Name = "FP1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "300.0"
    }
   0.datalabel([1062,1314],0,0,-1)
    {
    Name = "Thyr1A"
    }
   -Wire-([1062,1314],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1134,1314],0,29473944,370)
    {
    Name = "Thyr1A"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-10.0"
    Max = "40.0"
    }
   0.datalabel([1062,1350],0,0,-1)
    {
    Name = "Thyr2A"
    }
   -Wire-([1062,1350],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1134,1350],0,29478136,360)
    {
    Name = "Thyr2A"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-10.0"
    Max = "40.0"
    }
   -Wire-([198,828],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([234,828],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([270,828],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([198,864],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.ground([234,864],1,0,-1)
    {
    }
   -Wire-([198,756],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([270,756],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.varrlc([198,828],3,0,-1)
    {
    RLC = "2"
    R = "1.0 [ohm]"
    L = "1.0 [H]"
    C = "13.928"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([234,756],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.breaker3([234,720],1,0,440)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "0"
    ViewB = "0"
    DisPQ = "0"
    NAME = "BRK_CAP"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0E6 [ohm]"
    RON = "0.00001 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = ""
    IBRB = ""
    IBRC = ""
    IBR0 = ""
    SBRA = ""
    SBRB = ""
    SBRC = ""
    BP = ""
    BQ = ""
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "0 [MW]"
    Q = "0 [MVAR]"
    }
   -Wire-([198,648],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([234,612],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([270,576],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.compare([594,918],0,0,160)
    {
    X = "5.02"
    OL = "1"
    OH = "0"
    INTR = "0"
    }
   0.datalabel([666,918],0,0,-1)
    {
    Name = "BRK_CAP"
    }
   0.time-sig([486,918],0,0,150)
    {
    }
   -Wire-([522,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.unity([666,918],0,0,170)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([360,126],0,0,-1)
    {
    Name = "ANG"
    }
   -Wire-([324,126],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([360,126],0,29648768,20)
    {
    Name = "ANG"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.breaker1([594,252],0,0,520)
    {
    NAME = "BRK_SW"
    OPCUR = "0"
    ENAB = "0"
    ViewB = "0"
    CLVL = "0.0 [kA]"
    ROFF = "1.E6 [ohm]"
    RON = "0.005 [ohm]"
    PRER = "0.1 [ohm]"
    TD = "0.0 [s]"
    TDR = "0.05 [s]"
    PostIns = "0"
    TDBO = "0.005 [s]"
    IBR = ""
    SBR = ""
    BOpen = "2"
    }
   -Wire-([630,252],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.breaker1([594,378],0,0,490)
    {
    NAME = "BRK_SW"
    OPCUR = "0"
    ENAB = "0"
    ViewB = "0"
    CLVL = "0.0 [kA]"
    ROFF = "1.E6 [ohm]"
    RON = "0.005 [ohm]"
    PRER = "0.1 [ohm]"
    TD = "0.0 [s]"
    TDR = "0.05 [s]"
    PostIns = "0"
    TDBO = "0.005 [s]"
    IBR = ""
    SBR = ""
    BOpen = "2"
    }
   0.breaker1([594,504],0,0,460)
    {
    NAME = "BRK_SW"
    OPCUR = "0"
    ENAB = "0"
    ViewB = "0"
    CLVL = "0.0 [kA]"
    ROFF = "1.E6 [ohm]"
    RON = "0.005 [ohm]"
    PRER = "0.1 [ohm]"
    TD = "0.0 [s]"
    TDR = "0.05 [s]"
    PostIns = "0"
    TDBO = "0.005 [s]"
    IBR = ""
    SBR = ""
    BOpen = "2"
    }
   -Wire-([630,378],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([630,504],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.compare([594,846],0,0,130)
    {
    X = "5.01"
    OL = "0"
    OH = "1"
    INTR = "0"
    }
   0.datalabel([666,846],0,0,-1)
    {
    Name = "BRK_SW"
    }
   0.time-sig([486,846],0,0,120)
    {
    }
   -Wire-([522,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.unity([666,846],0,0,140)
    {
    IType = "2"
    OType = "1"
    }
   -Wire-([450,162],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Sticky-([18,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,108,180,144
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "Angle ALPHA is imported from the main page."
    }
   -Wire-([774,576],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([774,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.breakout([126,612],0,0,-1)
    {
    Dis = "0"
    }
   0.breakout([846,612],4,0,-1)
    {
    Dis = "0"
    }
   -Sticky-([18,792],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,792,126,828
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "1 MVA Capacitor bank"
    }
   -Sticky-([198,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 198,162,378,216
    Alignment = 0
    Style = 1
    Arrow = 128
    Color = 0,15792890
    Text = "Back to back thyristors used for the soft starting "
    }
   -Sticky-([720,738],0)
    {
    Name = ""
    Font = 1
    Bounds = 720,738,918,792
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
Main breaker signal - Closed after the machine has reached the full speed.
"
    }
   -Sticky-([720,810],0)
    {
    Name = ""
    Font = 1
    Bounds = 720,810,1098,918
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
Soft start breaker signal - The soft start mechanism is opened after the machine has reached full speed. The main breaker is closed to connect the wind generator to the system. The power flow is to the system at this time. Note that , initially, the generator operates in the motoring mode to build its speed.
"
    }
   0.annotation([1098,1152],0,0,-1)
    {
    AL1 = "Signals for plotting"
    AL2 = ""
    }
   -Sticky-([252,990],0)
    {
    Name = ""
    Font = 2
    Bounds = 252,990,702,1044
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Firing pulse generation for the thyristors."
    }
   -Sticky-([324,1512],0)
    {
    Name = ""
    Font = 1
    Bounds = 324,1512,594,1566
    Alignment = 0
    Style = 1
    Arrow = 49
    Color = 0,15792890
    Text = "System voltages are used as the reference for generating the firing pulses."
    }
   0.annotation([234,1350],0,0,-1)
    {
    AL1 = "Phase A"
    AL2 = ""
    }
   0.annotation([522,1350],0,0,-1)
    {
    AL1 = "Phase B"
    AL2 = ""
    }
   0.annotation([846,1350],0,0,-1)
    {
    AL1 = "Phase C"
    AL2 = ""
    }
   -Sticky-([720,936],0)
    {
    Name = ""
    Font = 1
    Bounds = 720,936,1098,1026
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Note: If the main breaker is kept closed from start with the soft start mechanism disables (BRK_SW open), the line currents and the initial reactive power are much higher."
    }
   -Sticky-([216,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 216,18,900,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
WIND FARM - INDUCTION MACHINE WITH SOFT STARTER
Breaker Module"
    }
   0.radiolink([324,126],4,0,10)
    {
    Source = "Main"
    Name = "Alpha"
    dim = "1"
    Mode = "0"
    Type = "0"
    }
   -Plot-([738,72],0)
    {
    Title = "Breaker Module: Graphs"
    Draw = 1
    Area = [0,0,450,468]
    Posn = [738,72]
    Icon = [-1,-1]
    Extents = 0,0,450,468
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,450,115],"")
     {
     Options = 9
     Units = ""
     Curve(29405720,"Ea",0,,,)
     Curve(29410024,"Eb",1,,,)
     Curve(29416256,"Ec",2,,,)
     }
    Graph([0,115],[0,0,450,115],"")
     {
     Options = 9
     Units = ""
     Curve(29421696,"ILa",0,,,)
     Curve(29459528,"ILb",1,,,)
     Curve(29463640,"ILc",2,,,)
     }
    Graph([0,230],[0,0,450,115],"")
     {
     Options = 9
     Units = ""
     Curve(29473944,"Thyr1A",0,,,)
     Curve(29478136,"Thyr2A",1,,,)
     }
    PGraph([0,345],[0,0,450,60],"PolyGraph")
     {
     Options = 2
     Curve(29469840,"FP1",0,,,1)
     }
    }
   0.varrlc([234,828],3,0,-1)
    {
    RLC = "2"
    R = "1.0 [ohm]"
    L = "1.0 [H]"
    C = "13.928"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([270,828],3,0,-1)
    {
    RLC = "2"
    R = "1.0 [ohm]"
    L = "1.0 [H]"
    C = "13.928"
    E = "0.0 [kV]"
    I = ""
    }
   }
  }
 Module("Main")
  {
  Desc = " EXAMPLE 7"
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Landscape,16,[619,473],100)
   {
   0.pgb([1134,972],0,29548456,360)
    {
    Name = "OMEGA"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "1.2"
    }
   -Wire-([1098,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1098,972],0,0,-1)
    {
    Name = "W"
    }
   -Wire-([1098,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,306],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   0.pgb([486,270],0,29553944,420)
    {
    Name = "TERMINAL VOLTAGE"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "16.0"
    }
   0.source3([702,306],4,0,50)
    {
    Name = "Source"
    Type = "2"
    Ctrl = "0"
    MVA = "3.0"
    Vm = "13.8 [kV]"
    F = "60.0 [Hz]"
    Tc = "0.0 [s]"
    ZSeq = "0"
    Imp = "0"
    Exph = "0"
    View = "1"
    Term = "0"
    R1s = "0.1 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.0001 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    R0p = "1.0 [ohm]"
    L0p = "0.1 [H]"
    Z0 = "1.0 [ohm]"
    Phi0 = "80.0 [deg]"
    Es = "13.8 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    VCtrl = "0"
    Vdes = "1.0 [pu]"
    Vbase = "230.0 [kV]"
    Tvm = "0.02 [s]"
    Tvc = "0.05 [s]"
    PCtrl = "0"
    Pdes = "1.0 [pu]"
    Tpm = "0.02 [s]"
    Tpc = "0.05 [s]"
    P = "P"
    Q = "Q"
    V = ""
    Theta = ""
    Ia = "Ia"
    Ib = "Ib"
    Ic = "Ic"
    }
   0.ground([738,306],0,0,-1)
    {
    }
   -Wire-([648,306],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([1134,936],0,29561208,370)
    {
    Name = "REACTIVE POWER GEN"
    Group = ""
    Display = "0"
    Scale = "2.5"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "5.0"
    }
   -Wire-([1098,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1098,936],0,0,-1)
    {
    Name = "QOUT"
    }
   0.pgb([1134,900],0,29565576,380)
    {
    Name = "REAL POWER GEN"
    Group = ""
    Display = "0"
    Scale = "2.5"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-4.0"
    Max = "3.0"
    }
   -Wire-([1098,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1098,900],0,0,-1)
    {
    Name = "POUT"
    }
   0.pgb([1134,1044],0,29569624,160)
    {
    Name = "REAL POWER SRC"
    Group = ""
    Display = "0"
    Scale = "3"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-4.0"
    Max = "1.0"
    }
   0.datalabel([1098,1044],0,0,-1)
    {
    Name = "P"
    }
   0.pgb([1134,1080],0,29573320,170)
    {
    Name = "REACTIVE POWER SRC"
    Group = ""
    Display = "0"
    Scale = "3"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "4.0"
    }
   0.datalabel([1098,1080],0,0,-1)
    {
    Name = "Q"
    }
   -Wire-([1098,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1098,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1062,1116],0,0,-1)
    {
    Name = "Ia"
    }
   -Wire-([1062,1116],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1134,1116],0,29579328,190)
    {
    Name = "Ia"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([1062,1152],0,0,-1)
    {
    Name = "Ib"
    }
   -Wire-([1062,1152],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1134,1152],0,29583056,210)
    {
    Name = "Ib"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-40.0"
    Max = "40.0"
    }
   0.datalabel([1062,1188],0,0,-1)
    {
    Name = "Ic"
    }
   -Wire-([1062,1188],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1134,1188],0,29587112,220)
    {
    Name = "Ic"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-40.0"
    Max = "40.0"
    }
   0.xy_transfer_function([1386,1098],0,0,330)
    {
    Xoff = "0.0"
    Yoff = "0.0"
    Kx = "1.0"
    Ky = "1.0"
    Mode = "0"
    Per = "0"
    Method = "1"
    InType = "0"
    N = "10"
    X1 = "0.0"
    Y1 = "175"
    X2 = "0.1"
    Y2 = "160"
    X3 = "0.2"
    Y3 = "150"
    X4 = "0.3"
    Y4 = "135"
    X5 = "0.4"
    Y5 = "120"
    X6 = "0.5"
    Y6 = "110"
    X7 = "0.6"
    Y7 = "105"
    X8 = "0.7"
    Y8 = "102"
    X9 = "0.8"
    Y9 = "100"
    X10 = "0.9"
    Y10 = "100"
    File = "datafile"
    path = "0"
    nl = "500"
    }
   0.datalabel([1296,1098],0,0,-1)
    {
    Name = "W"
    }
   -Wire-([1296,1098],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.sqc100([306,306],0,0,270)
    {
    Name = "Motor"
    Cnfg = "1"
    MM = "0"
    NOM = "1.0"
    Iter = "1"
    Vbase = "7.967 [kV]"
    Ibase = "0.1046"
    OMO = "60.0 [Hz]"
    View = "1"
    HP = "500 [hp]"
    noname1 = ""
    noname2 = ""
    noname3 = ""
    noname4 = ""
    noname5 = ""
    MSat = "0"
    LSat = "0"
    R1 = "0.066 [pu]"
    R2 = "0.298 [pu]"
    R3 = "0.018 [pu]"
    XL0 = "0.046 [pu]"
    XM0 = "3.86 [pu]"
    X230 = "0.122 [pu]"
    X3 = "0.105 [pu]"
    J = "1.70 [s]"
    D = "0.01 [pu]"
    DRatio = "1.0 [pu]"
    PFFLD = "0.85 [pu]"
    EFFLD = "0.985 [pu]"
    SFLD = "0.015 [pu]"
    CSTA = "5.0 [pu]"
    TRAT = "1.5 [pu]"
    TQMAX = "3.0 [pu]"
    Poles = "4"
    HINERT = "10.0"
    Hunit = "0"
    D2 = "0.008 [pu]"
    I1M = "0.0 [pu]"
    V1M = "0.0 [pu]"
    I2M = "0.5 [pu]"
    V2M = "0.5 [pu]"
    I3M = "0.8 [pu]"
    V3M = "0.79 [pu]"
    I4M = "1.0 [pu]"
    V4M = "0.947 [pu]"
    I5M = "1.2 [pu]"
    V5M = "1.076 [pu]"
    I6M = "1.5 [pu]"
    V6M = "1.2 [pu]"
    I7M = "1.8 [pu]"
    V7M = "1.26 [pu]"
    I8M = "2.2 [pu]"
    V8M = "1.32 [pu]"
    I9M = "3.2 [pu]"
    V9M = "1.53 [pu]"
    I10M = "4.2 [pu]"
    V10M = "1.74 [pu]"
    I1 = "0.0 [pu]"
    V1 = "0.0 [pu]"
    I2 = "1.196 [pu]"
    V2 = "0.286 [pu]"
    I3 = "1.82 [pu]"
    V3 = "0.4 [pu]"
    I4 = "2.861 [pu]"
    V4 = "0.564 [pu]"
    I5 = "5.882 [pu]"
    V5 = "0.981 [pu]"
    I6 = "-1.0 [pu]"
    V6 = "-1.0 [pu]"
    I7 = "-1.0 [pu]"
    V7 = "-1.0 [pu]"
    I8 = "-1.0 [pu]"
    V8 = "-1.0 [pu]"
    I9 = "-1.0 [pu]"
    V9 = "-1.0 [pu]"
    I10 = "-1.0 [pu]"
    V10 = "-1.0 [pu]"
    POut = "POUT"
    QOut = "QOUT"
    Theta = "PANG"
    Tmech = "TM"
    SP = "W"
    Telec = ""
    Tangle = ""
    Tslip = ""
    sfmi = ""
    sfli = ""
    }
   0.pgb([1134,1008],0,29600144,350)
    {
    Name = "MECH. TORQUE"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-1"
    Max = "1"
    }
   0.datalabel([1098,1008],0,0,-1)
    {
    Name = "TM"
    }
   .Breaker([612,306],6,0,40)
    {
    }
   0.const([198,270],0,0,10)
    {
    Name = ""
    Value = "0"
    }
   -Sticky-([1242,846],0)
    {
    Name = ""
    Font = 1
    Bounds = 1242,846,1530,1026
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "\
Firing angle of the soft starter is determined by this look up table. The look up table gives an ALPHA value based on the machine speed.

This is a simple implementation and the actual implementation in practical systems may have more controls and logic associated. These, if known, can be implemented using control blocks available in the PSCAD master library"
    }
   0.pgb([648,666],0,29605864,410)
    {
    Name = "Torque"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "0.4"
    Max = "1.0"
    }
   0.pgb([648,702],0,29609616,400)
    {
    Name = "PT (pu)"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([558,846],0,0,-1)
    {
    Name = "BETA"
    }
   0.pgb([558,846],0,29613560,390)
    {
    Name = "Beta"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "9.0"
    Max = "16.0"
    }
   0.var([54,666],0,29616296,60)
    {
    Name = "Es"
    Group = ""
    Display = "0"
    Max = "30"
    Min = "0.0"
    Value = "6.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([90,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([126,666],0,0,-1)
    {
    Name = "ES"
    }
   0.datalabel([360,666],0,0,-1)
    {
    Name = "Vw"
    }
   0.wind_turbine([558,684],0,0,320)
    {
    Gmva = "2.5 [MVA]"
    Wrat = "20.0 [Hz]"
    Rad = "40 [m]"
    Area = "5026 [m*m]"
    Airden = "1.229 [kg/m^3]"
    Eff = "0.97 [pu]"
    Gratio = "GR"
    Mod = "0"
    }
   -Wire-([468,774],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.compare([270,1062],0,0,150)
    {
    X = "6"
    OL = "0"
    OH = "1"
    INTR = "0"
    }
   0.time-sig([198,1062],0,0,140)
    {
    }
   0.wind_governor([558,972],0,0,250)
    {
    Pcnt = "1"
    Gen = "0"
    Wrat = "60 [Hz]"
    Tmva = "2 [MW]"
    Gmva = "2.5 [MVA]"
    Gov = "0"
    Gr = "GR"
    Pref = "2 [MW]"
    Wref = "60 [Hz]"
    Kp = "6.2 [deg/pu]"
    Ki = "6.2 [deg/pu]"
    Piul = "100"
    Pill = "-100"
    Ks = "0.05 [deg/pu]"
    Gmul = "30 [deg/pu]"
    Dwm = "0.2 [rad/s]"
    Bo = "12 [deg]"
    K4 = "0.1 [s]"
    Arl = "1"
    Rl = "10.0 [deg/s]"
    Pal = "1"
    Bll = "0 [deg]"
    Bul = "25 [deg]"
    Nf = "0"
    Type = "5"
    Wf = "10.0 [rad/s]"
    Df = "0.3"
    }
   0.datalabel([288,990],0,0,-1)
    {
    Name = "Pw"
    }
   -Wire-([558,918],0,0,-1)
    {
    Vertex="0,0;0,-162"
    }
   0.select([450,1026],0,0,240)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([324,1062],4,0,-1)
    {
    Name = "CNT"
    }
   0.const([378,1026],0,0,130)
    {
    Name = ""
    Value = "1"
    }
   -Wire-([306,1062],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([360,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([468,702],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([630,666],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([630,702],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([270,666],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   0.wind_source([198,666],0,0,70)
    {
    EXT = "1"
    BWV = "8 [m/s]"
    Gust = "0"
    Ramp = "0"
    Noise = "0"
    Damp = "0"
    TC = "0.025 [s]"
    MAXG = "1 [m/s]"
    TG = "2 [s]"
    T1G = "3"
    NG = "1"
    MAXR = "1 [m/s]"
    TR = "1 [s]"
    T1R = "6"
    NR = "1"
    N = "50"
    DW = "1 [rad/s]"
    Kn = "0.0192"
    F = "600 [m]"
    ISEED = "8"
    TRM = "0.35 [s]"
    }
   -Wire-([486,1026],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([324,1062],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.const([90,774],0,0,80)
    {
    Name = ""
    Value = "1.0"
    }
   -Wire-([90,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.select([162,774],0,0,280)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([90,738],0,0,-1)
    {
    Name = "w"
    }
   0.datalabel([162,810],0,0,-1)
    {
    Name = "CNT"
    }
   0.mult([288,774],0,0,290)
    {
    }
   -Wire-([198,774],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var([846,1116],0,29743576,180)
    {
    Name = "GR"
    Group = ""
    Display = "0"
    Max = "200"
    Min = "0.0"
    Value = "55.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([882,1116],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([954,1116],0,0,-1)
    {
    Name = "GR"
    }
   -ControlPanel-([846,954],0)
    {
    Name = "Controls"
    Flags = 0
    State = 1
    Icon = 882,1098
    Posn = 846,954
    Extents = 0,0,144,126
    Slider(29616296)
    Slider(29743576)
    }
   -Wire-([864,1152],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([936,1152],0,29765856,200)
    {
    Name = "Wind speed (m/s)"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "m/s"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([864,1152],0,0,-1)
    {
    Name = "Vw"
    }
   0.gain([198,342],6,0,260)
    {
    G = "-1"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([648,666],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   0.datalabel([648,558],6,0,-1)
    {
    Name = "Twind"
    }
   0.datalabel([144,342],6,0,-1)
    {
    Name = "Twind"
    }
   -Wire-([144,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([468,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 468,18,1152,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
WIND FARM - INDUCTION MACHINE WITH SOFT STARTER
"
    }
   -Sticky-([324,702],0)
    {
    Name = ""
    Font = 1
    Bounds = 324,702,432,738
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "\
Actual hub speed of machine
"
    }
   -Sticky-([72,846],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,846,342,900
    Alignment = 0
    Style = 1
    Arrow = 32
    Color = 0,15792890
    Text = "\
A six Pole Machine
Mechanical speed = W(pu)*2*pi*f/(pole paris)
"
    }
   -Sticky-([180,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 180,1116,342,1170
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Signal CNT enables the pitch angle dynamics
Enabled at 6 sec."
    }
   -Sticky-([522,1044],0)
    {
    Name = ""
    Font = 1
    Bounds = 522,1044,720,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Initial Pitch angle and the Power reference (demand) are inputs to this module.
For this example :
Initial pitch angle = 12 deg
Power demand =  2.0 MW"
    }
   -Sticky-([72,540],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,540,306,594
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Use this component to study a wind gust or a ramp and see the response of the control systems."
    }
   -Sticky-([846,846],0)
    {
    Name = ""
    Font = 1
    Bounds = 846,846,1008,918
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "\
GR - Gear Ratio
Es - External signal for wind speed
"
    }
   0.multimeter([360,306],0,0,30)
    {
    MeasI = "0"
    MeasV = "0"
    MeasP = "1"
    MeasQ = "1"
    RMS = "2"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = ""
    P = "Pw"
    Q = "Qw"
    Vrms = "Vrms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([414,270],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([414,270],0,0,-1)
    {
    Name = "Vrms"
    }
   0.annotation([288,360],0,0,-1)
    {
    AL1 = "2.5 MVA Machine"
    AL2 = ""
    }
   -Sticky-([486,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 486,162,684,216
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Main breaker and softstart model including firing controls"
    }
   -Sticky-([36,54],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,54,396,216
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Power electronic switching is used to reduce the starting transients when connecting a wind driven induction generator to the system. The machine is first connected to the wind turbine and once the speed is close to 1 pu, it is connected to the system via the soft starting switches. 

If the main breaker is closed without the use of soft starting techniques, the starting currents are much higher and may not be acceptable."
    }
   0.consti([198,306],0,0,20)
    {
    Name = ""
    Value = "0"
    }
   0.radiolink([1422,1098],0,0,340)
    {
    Source = ""
    Name = "Alpha"
    dim = "1"
    Mode = "1"
    Type = "0"
    }
   -Divider-([36,468],0)
    {
    Size(792,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([846,810],0)
    {
    Size(702,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.emtconst([252,810],0,0,90)
    {
    Name = ""
    Value = "1"
    }
   0.mult([360,774],0,0,300)
    {
    }
   0.const([324,810],0,0,100)
    {
    Name = "frequency"
    Value = "60.0"
    }
   0.mult([432,774],0,0,310)
    {
    }
   0.emtconst([396,810],0,0,110)
    {
    Name = "1/(pole pairs)"
    Value = "13"
    }
   -Sticky-([666,360],0)
    {
    Name = ""
    Font = 1
    Bounds = 666,360,774,396
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "3 MVA network "
    }
   0.const([288,1026],6,0,120)
    {
    Name = "1/2.5"
    Value = "0.4"
    }
   -Sticky-([342,936],0)
    {
    Name = ""
    Font = 1
    Bounds = 342,936,450,972
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Measured PU power"
    }
   0.mult([324,990],0,0,230)
    {
    }
   -Plot-([1008,828],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 0
    Area = [0,0,576,288]
    Posn = [252,792]
    Icon = [1008,828]
    Extents = 0,0,288,18
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,288,90],"y")
     {
     Options = 128
     Units = ""
     Curve(29565576,"REAL POWER GEN",0,,,)
     }
    Graph([0,90],[0,0,288,90],"y")
     {
     Options = 0
     Units = ""
     Curve(29561208,"REACTIVE POWER GEN",0,,,)
     }
    }
   -Plot-([882,774],0)
    {
    Title = "Pitch Angle And Torque"
    Draw = 0
    Area = [0,0,666,342]
    Posn = [144,450]
    Icon = [882,774]
    Extents = 0,0,288,18
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,288,90],"Pitch Angle")
     {
     Options = 1
     Units = ""
     Curve(29613560,"Beta",0,,,)
     }
    Graph([0,90],[0,0,288,90],"Torque")
     {
     Options = 1
     Units = ""
     Curve(29605864,"Torque",0,,,)
     }
    }
   -Plot-([882,90],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,666,666]
    Posn = [882,90]
    Icon = [-1,-1]
    Extents = 0,0,666,666
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,666,121],"Power")
     {
     Options = 9
     Units = ""
     Curve(29569624,"REAL POWER SRC",1,,,)
     }
    Graph([0,121],[0,0,666,121],"Reactive Power")
     {
     Options = 9
     Units = ""
     Curve(29573320,"REACTIVE POWER SRC",0,,,)
     }
    Graph([0,242],[0,0,666,121],"Speed")
     {
     Options = 9
     Units = ""
     Curve(29548456,"OMEGA",0,,,)
     }
    Graph([0,363],[0,0,666,120],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(29553944,"TERMINAL VOLTAGE",0,,,)
     }
    Graph([0,483],[0,0,666,120],"Current")
     {
     Options = 9
     Units = ""
     Curve(29579328,"Ia",0,,,)
     }
    }
   }
  }
 }

